<?php
<?php
// دریافت همه سفارشات از ووکامرس
function getOrdersReal($config){
    $url = rtrim($config['woocommerce']['url'], '/') . '/wp-json/wc/v3/orders';
    $ck = $config['woocommerce']['key'];
    $cs = $config['woocommerce']['secret'];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_USERPWD, $ck . ":" . $cs);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);

    $orders = json_decode($result, true);

    if($orders === null) return []; // خطا
    if(empty($orders)) return [];    // بدون سفارش

    return $orders;
}

// گرفتن آخرین سفارش
function getLastOrder($config){
    $orders = getOrdersReal($config);
    if(empty($orders)) return null;
    return end($orders);
}

// گرفتن n سفارش آخر
function getLastNOrders($config, $n = 5){
    $orders = getOrdersReal($config);
    if(empty($orders)) return [];
    return array_slice($orders, -$n);
}

// جستجو بر اساس شماره سفارش
function findOrderById($config, $orderId){
    $orders = getOrdersReal($config);
    if(empty($orders)) return null;

    foreach($orders as $o){
        if($o['id'] == $orderId){
            return $o;
        }
    }
    return null;
}
?>
