<?php
$config = json_decode(file_get_contents('config.json'), true);
$botToken = $config['bot_token'];
$logFile = 'log.txt';
$updateRaw = file_get_contents('php://input');
file_put_contents($logFile, date('Y-m-d H:i:s') . " RAW INPUT:\n" . $updateRaw . "\n\n", FILE_APPEND);
$update = json_decode($updateRaw, true);

include 'orders.php';
include 'products.php';
include 'users.php';
include 'support.php';

if(isset($update['message'])){
    $chatId = $update['message']['chat']['id'];
    $text = $update['message']['text'] ?? '';

    // خوشامدگویی و دکمه‌ها برای /start
    if($text === '/start'){
        $welcomeMessage = "✨ سلام! خوش آمدید به ربات ووکامرس ما! ✨\nلطفاً یکی از گزینه‌های زیر را انتخاب کنید:";

        $keyboard = [
            'keyboard' => [
                [['text' => 'سفارشات']],
                [['text' => 'محصولات']],
                [['text' => 'کاربران']],
                [['text' => 'پشتیبانی']]
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => true
        ];

        $postData = [
            'chat_id' => $chatId,
            'text' => $welcomeMessage,
            'reply_markup' => json_encode($keyboard)
        ];

        sendTelegramMessage($botToken, $postData, $logFile);

    } else {
        // پاسخ بر اساس دکمه‌ها
       switch($text){
    case 'سفارشات':
        $orders = getOrdersReal($config);
        if(empty($orders)){
            $msg = "📦 شما هیچ سفارشی ندارید.";
        } else {
            $msg = "📦 لیست سفارشات:\n";
            foreach($orders as $o){
                $msg .= "ID: {$o['id']} | کاربر: {$o['billing']['first_name']} | مبلغ: {$o['total']} | وضعیت: {$o['status']}\n";
            }
        }
        break;

    case 'محصولات':
        $products = getProductsReal($config);
        if(empty($products)){
            $msg = "🛍️ هیچ محصولی یافت نشد.";
        } else {
            $msg = "🛍️ لیست محصولات:\n";
            foreach($products as $p){
                $msg .= "ID: {$p['id']} | {$p['name']} | قیمت: {$p['price']} | موجودی: {$p['stock_quantity']}\n";
            }
        }
        break;

    case 'کاربران':
        $users = getUsersReal($config);
        if(empty($users)){
            $msg = "👤 شما هیچ کاربری ندارید.";
        } else {
            $msg = "👤 لیست کاربران:\n";
            foreach($users as $u){
                $msg .= "ID: {$u['id']} | {$u['first_name']} {$u['last_name']} | ایمیل: {$u['email']}\n";
            }
        }
        break;

    case 'پشتیبانی':
        $msg = getSupportContact();
        break;

    default:
        $msg = "شما پیام دادید: $text";
}



        $postData = [
            'chat_id' => $chatId,
            'text' => $msg
        ];

        sendTelegramMessage($botToken, $postData, $logFile);
    }
}

// تابع ارسال پیام و لاگ
function sendTelegramMessage($botToken, $data, $logFile){
    $url = "https://api.telegram.org/bot$botToken/sendMessage";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    file_put_contents($logFile, date('Y-m-d H:i:s') . " SENT RESPONSE:\n" . $result . "\n\n", FILE_APPEND);
}
?>
